//=============================================================================
// House Keeper Gun, allows you to manage your house!
//=============================================================================
class HouseKeeperGun extends DeusExWeapon;

var int XMode;

var int CurCost;
var class<inventory> CurProduct;

var CompanionCubeHD CurrentCC;

replication
{
     reliable if (Role == ROLE_Authority)
        InvokeCompanionWindow, XMode;

     reliable if (Role < ROLE_Authority)
        ForwardMultiskin, BackwardMultiskin;
}

simulated function bool TestMPBeltSpot(int BeltSpot)
{
   return (BeltSpot == 4);
}

state NormalFire
{
Begin:
	if ((ClipCount >= ReloadCount) && (ReloadCount != 0))
	{
		if (!bAutomatic)
		{
			bFiring = False;
			FinishAnim();
		}

		if (Owner != None)
		{
			if (Owner.IsA('DeusExPlayer'))
			{
				bFiring = False;


				// should we autoreload?
				if (DeusExPlayer(Owner).bAutoReload)
				{
					// auto switch ammo if we're out of ammo and
					// we're not using the primary ammo
					if ((AmmoType.AmmoAmount == 0) && (AmmoName != AmmoNames[0]))
						CycleAmmo();
					ReloadAmmo();
				}
				else
				{
					if (bHasMuzzleFlash)
						EraseMuzzleFlashTexture();
					GotoState('Idle');
				}
			}
			else if (Owner.IsA('ScriptedPawn'))
			{
				bFiring = False;
				ReloadAmmo();
			}
		}
		else
		{
			if (bHasMuzzleFlash)
				EraseMuzzleFlashTexture();
			GotoState('Idle');
		}
	}
	if ( bAutomatic && (( Level.NetMode == NM_DedicatedServer ) || ((Level.NetMode == NM_ListenServer) && Owner.IsA('DeusExPlayer') && !DeusExPlayer(Owner).PlayerIsListenClient())))
		GotoState('Idle');

	Sleep(GetShotTime());
	if (bAutomatic)
	{
		GenerateBullet();	// In multiplayer bullets are generated by the client which will let the server know when
		Goto('Begin');
	}
	bFiring = False;
	FinishAnim();

	ReadyToFire();
Done:
	bFiring = False;
	Finish();
}


simulated function CycleAmmo()
{

 if (XMode == 0 && CurProduct != None)
 {
  XMode = 1;
  Pawn(Owner).ClientMessage("|c88ff88Now adding current product of |p4"$CurProduct$" for $"$CurCost$".");
  return; 
 }

 else if (XMode == 0 && CurProduct == None)
 {
  XMode = 2;
  Pawn(Owner).ClientMessage("|cffff88fNow removing products within shot radius.");
  return; 
 }

 else if (XMode == 1)
 {
  XMode = 2;
  Pawn(Owner).ClientMessage("|cffff88Now removing products within shot radius.");
  return; 
 }

 else if (XMode == 2)
 {
  XMode = 0;
  Pawn(Owner).ClientMessage("|c8888ffNow set to multi-purpose utility mode.");
  return; 
 }
}

function string GetOwnerIP()
{
 local string CurIP;
 
 CurIP = PlayerPawn(Owner).GetPlayerNetworkAddress();
 CurIP = Left(CurIP, InStr(CurIP, ":"));
 
 return CurIP;
}

function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
 if(XMode == 0)
 {
  //Pastings from 1I1 because I'm replication R-tard.

  //if (Other.IsA('CompanionCubeHD') && Other.Owner == DeusExPlayer(Owner))
  //{
	if(CompanionCubeHD(Other) != None)
	{
		if (CompanionCubeHD(Other).OwnersIP ~= GetOwnerIP())
		{
			if(currentCC != None)
			{
				currentCC = None;
			}
			currentCC = CompanionCubeHD(Other);
   			InvokeCompanionWindow();
		}
	}
  //}

  if (Other.IsA('CustomStereo') && Other.Owner == Owner)
  {
   //InvokeStereoWindow(CustomStereo(Other));
  }
  if (Other.IsA('CustomHouseKeypad') && Other.Owner == Owner)
  {
   //InvokeKeypadWindow(CustomHouseKeypad(Other));
  }
  if (Other.IsA('InvitePlaque') && Other.Owner == Owner)
  {
   //InvokeInvitationWindow(InvitePlaque(Other));
  }
  if (Other.IsA('DeusExPlayer') && IsInOwnHouse())
  {
   RevokeInvite(DeusExPlayer(Other));
  }
  if (Other.IsA('CustomTV') && Other.Owner == Owner)
  {
   //CustomTV(Other).CycleProgram();
  }
  if (Other.IsA('CustomBed') && Other.Owner == Owner)
  {
   //CustomBed(Other).CycleSkin();
  }
 }
 if (XMode == 1)
 {
  if (CanAffordProduct() && CurProduct != None)
  {
   PlaceProduct(hitLocation, CurCost);
   XMode = 0;
   return;
  }
  
  Pawn(Owner).ClientMessage("|cf88000Insufficient Cash.");
 }
 if (XMode == 2)
 {
  RemoveProducts(hitLocation);
 }
}

function RevokeInvite(DeusExPlayer P)
{
}

function Texture GetMultiskin(int i)
{
 //if (CurrentCC == None) return Texture'CCBlack';
 
 return CurrentCC.GetMultiskin(i);
 //return CurrentCC.GetMeshTexture(i);
 //return CurrentCC.Multiskins[i];
}

function ForwardMultiskin(int i)
{
 if (CurrentCC == None) return;
 
 CurrentCC.ForwardMultiskin(i);
}

function BackwardMultiskin(int i)
{
 if (CurrentCC == None) return;
 
 CurrentCC.BackwardMultiskin(i);
}

simulated function InvokeCompanionWindow()
{
	local DeusExPlayer _Player;
	local DeusExRootWindow _root;
	local MSCMenuCCColors _CCWindow;
	//local HouseKeeperGun _WindowOwner;

	_Player = DeusExPlayer(Owner);
	//_WindowOwner = Self;

	if(_Player != None)
	{
		_Player.InitRootWindow();
		_root = DeusExRootWindow(_Player.rootWindow);
		if(_root != None)
		{
			_CCWindow = MSCMenuCCColors(_root.InvokeUIScreen(Class'MSCMenuCCColors', True));
			if(_CCWindow != None)
			{
				_CCWindow._WindowOwner = Self;
				_CCWindow.UpdateInfo();
			}
		}
	}
}

function bool IsInOwnHouse()
{
 
 
 return false;
}

function bool CanAffordProduct()
{
 
 
 return false;
}

function PlaceProduct(vector Loc, int Cost)
{
}

function RemoveProducts(vector Loc)
{
}

defaultproperties
{
     LowAmmoWaterMark=0
     GoverningSkill=Class'DeusEx.SkillWeaponLowTech'
     NoiseLevel=0.050000
     EnemyEffective=ENMEFF_Organic
     Concealability=CONC_Visual
     reloadTime=0.000000
     maxRange=8192
     AccurateRange=4096
     BaseAccuracy=0.000000
     bHasMuzzleFlash=True
     bHandToHand=False
     bFallbackWeapon=True
     mpHitDamage=0
     mpBaseAccuracy=1.000000
     mpAccurateRange=4096
     mpMaxRange=8192
     AmmoName=Class'DeusEx.AmmoNone'
     ReloadCount=0
     bInstantHit=True
     FireOffset=(X=-5.000000,Y=8.000000,Z=14.000000)
     shakemag=20.000000
     FireSound=Sound'DeusExSounds.Weapons.PistolFire'
     SelectSound=Sound'DeusExSounds.Weapons.PistolSelect'
     InventoryGroup=243
     ItemName="|p4House Owner's Gun"
     PlayerViewOffset=(X=22.000000,Y=-10.000000,Z=-14.000000)
     PlayerViewMesh=LodMesh'Glock'
     PickupViewMesh=LodMesh'GlockPickup'
     ThirdPersonMesh=LodMesh'Glock3rd'
     Icon=Texture'DeusExUI.Icons.BeltIconPistol'
     largeIcon=Texture'DeusExUI.Icons.LargeIconPistol'
     largeIconWidth=47
     largeIconHeight=44
     Description="If you are reading this than you are obviously not playing with other people..."
     beltDescription="|p4HOUSEGUN"
     Mesh=LodMesh'DeusExItems.GlockPickup'
     CollisionRadius=12.65
     CollisionHeight=0.800000
     HitDamage=0
}
